import requests
import json
import configparser
from Log_in import sign_in
from datetime import datetime
"""
Use case 1:
This code demonstrates how measurements from a sector can be retrieved
"""
def temperature(page_url):
    response = requests.request("GET", page_url, headers=headers, data=payload)
    for line in json.loads(response.text)["data"]:
        print((line["attributes"])["timestamp"] + "\t"  + ((line["attributes"])["cdata"])["formatted"] )
    return json.loads(response.text)["links"]


def location_sector(page_url):
    response = requests.request("GET", page_url, headers=headers, data=payload)
    if response.status_code in [200]:
        for line in json.loads(response.text)["data"]:
            print("ID: " + line["id"] + "\tName: " + (line["attributes"])["name"] )
        return json.loads(response.text)["links"]
    else:
        print(response.text)
        quit()

def pagination(api_url, wanted_func):

    if wanted_func == "temp":
        wanted_function = temperature
    elif wanted_func == "location/sector":
        wanted_function = location_sector

    page_link = wanted_function(api_url)
    while page_link["next"] != page_link["last"]:
        page_link = wanted_function(page_link["next"])

    if(page_link["first"] != page_link["last"]):
        wanted_function(page_link["next"])

sign_in_data = sign_in()

Token = sign_in_data[0]
url = sign_in_data[1]

payload={}
headers = {
  'Authorization': 'Bearer ' + Token
}

def main():
    pagination(url + "/api/1.0/locations?filter[status]=enabled", "location/sector")
    Location_id = input("Enter the ID of the Location you wish to use: ")
    pagination(url + "/api/1.0/locations/" + Location_id +"/sectors",  "location/sector")
    Sector_id = input("Enter the ID of the Sector you wish to retrieve the measurments from:")
    pagination(url +"/api/1.0/sectors/"+ Sector_id +"/measurements",  "temp")

if __name__ == "__main__":
    main()
